<?php
// Configura la visualización de errores para la depuración
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Configura los encabezados para permitir peticiones desde tu landing page (CORS)
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Revisa si la petición es un método POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(array("error" => "Método no permitido."));
    exit();
}

// Obtiene el cuerpo de la petición en formato JSON
$data = json_decode(file_get_contents("php://input"));

// **Configuración de la base de datos MySQL**
$servername = "localhost";
$username = "b100even_invites";
$password = "BuqL)Kl(+Rk9";
$dbname = "b100even_coctelco";

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // **VERIFICA SI EL EMAIL YA EXISTE EN LA BASE DE DATOS**
    $checkStmt = $conn->prepare("SELECT COUNT(*) FROM rsvpsfuerza WHERE email = ?");
    $checkStmt->execute([$data->email]);
    $count = $checkStmt->fetchColumn();

    if ($count > 0) {
        http_response_code(409); // 409 Conflict
        echo json_encode(array("error" => "Error, este email ya está registrado"));
        exit();
    }

    // SQL para insertar datos en la tabla `rsvpsfuerza`
    // Se ha agregado el campo 'empresa' a la consulta
    $sql = "INSERT INTO rsvpsfuerza (nombre, apellido, empresa, telefono, email, acompanante, sin_acompanante) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->execute([
        $data->nombre, 
        $data->apellido, 
        $data->empresa, // <-- Aquí se incluye el dato de la empresa
        $data->telefono, 
        $data->email,
        $data->acompanante,
        $data->sin_acompanante, 
        // 'buyers' // <-- Se mantiene el valor 'buyers'
    ]);

    // Envía una respuesta exitosa
    echo json_encode(array("message" => "Confirmación recibida y datos guardados."));

} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode(array("error" => "Error en la base de datos: " . $e->getMessage()));
} catch(Exception $e) {
    http_response_code(500);
    echo json_encode(array("error" => "El mensaje no pudo ser procesado. Error: " . $e->getMessage()));
}

$conn = null;
?>
